/*
 * Decompiled with CFR 0.152.
 */
package net.ftb.tools;

import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import net.ftb.data.ModPack;
import net.ftb.data.Settings;
import net.ftb.gui.LaunchFrame;
import net.ftb.gui.dialogs.ModpackUpdateDialog;
import net.ftb.log.Logger;
import net.ftb.util.DownloadUtils;
import net.ftb.util.ErrorUtils;
import net.ftb.util.FileUtils;
import net.ftb.util.OSUtils;
import net.ftb.util.TrackerUtils;

public class ModManager
extends JDialog {
    public static boolean update = false;
    public static boolean backupCFG = false;
    public static boolean backupSave = false;
    public static boolean erroneous = false;
    public static boolean upToDate = false;
    private static String curVersion = "";
    private JPanel contentPane;
    private double downloadedPerc;
    private final JProgressBar progressBar;
    private final JLabel label;
    private static String sep = File.separator;
    public static ModManagerWorker worker;
    private static File baseDynamic;

    public ModManager(JFrame owner, Boolean model) {
        super((Frame)owner, (boolean)model);
        this.setResizable(false);
        this.setTitle("Downloading...");
        this.setDefaultCloseOperation(1);
        this.setBounds(100, 100, 313, 138);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(null);
        this.progressBar = new JProgressBar();
        this.progressBar.setBounds(10, 63, 278, 22);
        this.contentPane.add(this.progressBar);
        JLabel lblDownloadingModPack = new JLabel("<html><body><center>Downloading mod pack...<br/>Please Wait</center></body></html>");
        lblDownloadingModPack.setHorizontalAlignment(0);
        lblDownloadingModPack.setBounds(0, 5, 313, 30);
        this.contentPane.add(lblDownloadingModPack);
        this.label = new JLabel("");
        this.label.setHorizontalAlignment(0);
        this.label.setBounds(0, 42, 313, 14);
        this.contentPane.add(this.label);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent arg0) {
                worker = new ModManagerWorker(){

                    @Override
                    protected void done() {
                        ModManager.this.setVisible(false);
                        super.done();
                    }
                };
                worker.execute();
            }
        });
    }

    private boolean upToDate() throws IOException {
        int currentVersion;
        ModPack pack = ModPack.getSelectedPack();
        File version = new File(Settings.getSettings().getInstallPath(), pack.getDir() + sep + "version");
        if (!version.exists()) {
            version.getParentFile().mkdirs();
            version.createNewFile();
            curVersion = (Settings.getSettings().getPackVer().equalsIgnoreCase("recommended version") ? pack.getVersion() : Settings.getSettings().getPackVer()).replace(".", "_");
            return false;
        }
        BufferedReader in = new BufferedReader(new FileReader(version));
        String line = in.readLine();
        in.close();
        int n = currentVersion = line != null ? Integer.parseInt(line.replace(".", "")) : 0;
        if (!Settings.getSettings().getPackVer().equalsIgnoreCase("recommended version") && !Settings.getSettings().getPackVer().equalsIgnoreCase("newest version")) {
            int requestedVersion = Integer.parseInt(Settings.getSettings().getPackVer().trim().replace(".", ""));
            if (requestedVersion != currentVersion) {
                Logger.logInfo("Modpack is out of date.");
                curVersion = (Settings.getSettings().getPackVer().equalsIgnoreCase("recommended version") ? pack.getVersion() : Settings.getSettings().getPackVer()).replace(".", "_");
                return false;
            }
            Logger.logInfo("Modpack is up to date.");
            return true;
        }
        if (Integer.parseInt(pack.getVersion().replace(".", "")) != currentVersion) {
            File destination;
            Logger.logInfo("Modpack is out of date.");
            if (LaunchFrame.allowVersionChange) {
                curVersion = (Settings.getSettings().getPackVer().equalsIgnoreCase("recommended version") ? pack.getVersion().replace(".", "_") : Settings.getSettings().getPackVer()).replace(".", "_");
                return false;
            }
            ModpackUpdateDialog p = new ModpackUpdateDialog(LaunchFrame.getInstance(), true);
            p.setVisible(true);
            if (!update) {
                return true;
            }
            if (backupCFG) {
                destination = new File(OSUtils.getCacheStorageLocation(), "backups" + sep + pack.getDir() + sep + "config_backup");
                if (destination.exists()) {
                    FileUtils.delete(destination);
                }
                FileUtils.copyFolder(new File(Settings.getSettings().getInstallPath(), pack.getDir() + sep + "minecraft" + sep + "config"), destination);
            }
            if (backupSave) {
                destination = new File(OSUtils.getCacheStorageLocation(), "backups" + sep + pack.getDir() + sep + "saves_backup");
                if (destination.exists()) {
                    FileUtils.delete(destination);
                }
                FileUtils.copyFolder(new File(Settings.getSettings().getInstallPath(), pack.getDir() + sep + "minecraft" + sep + "saves"), destination);
            }
            curVersion = pack.getVersion().replace(".", "_");
            return false;
        }
        Logger.logInfo("Modpack is up to date.");
        return true;
    }

    public static void cleanUp() {
        ModPack pack = ModPack.getSelectedPack();
        File tempFolder = new File(OSUtils.getCacheStorageLocation(), "ModPacks" + sep + pack.getDir() + sep);
        for (String file : tempFolder.list()) {
            if (file.equals(pack.getLogoName()) || file.equals(pack.getImageName()) || file.equals("version") || file.equals(pack.getAnimation())) continue;
            try {
                if (file.endsWith(".zip")) {
                    Logger.logDebug("retaining modpack file: " + tempFolder + File.separator + file);
                    continue;
                }
                FileUtils.delete(new File(tempFolder, file));
            }
            catch (IOException e) {
                Logger.logError(e.getMessage(), e);
            }
        }
    }

    public static void clearModsFolder(ModPack pack) {
        File modsFolder = new File(Settings.getSettings().getInstallPath(), pack.getDir() + File.separator + "minecraft" + File.separator + "mods");
        ModManager.clearFolder(modsFolder);
        Logger.logInfo("Mods Folder: " + modsFolder.toString());
        File dyn = new File(baseDynamic.getPath(), "minecraft" + File.separator + "mods");
        Logger.logInfo("Dynamic Folder: " + dyn);
        ModManager.clearFolder(dyn);
    }

    public static void clearFolder(File folder) {
        if (folder.exists()) {
            for (String file : folder.list()) {
                if (new File(folder, file).isDirectory()) {
                    ModManager.clearFolder(new File(folder, file));
                }
                if (!file.toLowerCase().endsWith(".zip") && !file.toLowerCase().endsWith(".jar") && !file.toLowerCase().endsWith(".disabled") && !file.toLowerCase().endsWith(".litemod")) continue;
                try {
                    boolean b = FileUtils.delete(new File(folder, file));
                    if (b) continue;
                    Logger.logInfo("Error deleting " + file);
                }
                catch (IOException e) {
                    Logger.logWarn(e.getMessage(), e);
                }
            }
        }
    }

    public class ModManagerWorker
    extends SwingWorker<Boolean, Void> {
        @Override
        protected Boolean doInBackground() {
            try {
                if (!ModManager.this.upToDate()) {
                    File animationGif;
                    String installPath = OSUtils.getCacheStorageLocation();
                    ModPack pack = ModPack.getSelectedPack();
                    pack.setUpdated(true);
                    File modPackZip = new File(installPath, "ModPacks" + sep + pack.getDir() + sep + pack.getUrl());
                    if (modPackZip.exists()) {
                        FileUtils.delete(modPackZip);
                    }
                    if ((animationGif = new File(OSUtils.getCacheStorageLocation(), "ModPacks" + sep + pack.getDir() + sep + pack.getAnimation())).exists()) {
                        FileUtils.delete(animationGif);
                    }
                    String dynamicLoc = OSUtils.getCacheStorageLocation();
                    baseDynamic = new File(dynamicLoc, "ModPacks" + sep + pack.getDir() + sep);
                    erroneous = !this.downloadModPack(pack.getUrl(), pack.getDir());
                }
            }
            catch (IOException e) {
                Logger.logError("Error while updating modpack", e);
            }
            return true;
        }

        public String downloadUrl(String filename, String urlString) {
            FileOutputStream fout;
            BufferedInputStream in = null;
            HttpURLConnection connection = null;
            String md5 = "";
            int amount = 0;
            int startAmount = -1;
            int modPackSize = 0;
            int steps = 0;
            int retryCount = 5;
            try {
                fout = new FileOutputStream(filename);
            }
            catch (IOException e) {
                Logger.logError("Failed opening output file: " + filename, e);
                return null;
            }
            do {
                try {
                    int count;
                    startAmount = amount;
                    if (amount > 0) {
                        Logger.logInfo("Resuming download from offset " + Integer.toString(amount));
                    }
                    URL url_ = new URL(urlString);
                    byte[] data = new byte[1024];
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ModManager.this.progressBar.setMaximum(10000);
                        }
                    });
                    connection = (HttpURLConnection)url_.openConnection();
                    connection.setRequestProperty("Cache-Control", "no-transform");
                    connection.setAllowUserInteraction(true);
                    connection.setConnectTimeout(14000);
                    connection.setReadTimeout(20000);
                    if (amount > 0) {
                        connection.setRequestProperty("Range", "bytes=" + amount + "-");
                    }
                    connection.connect();
                    md5 = connection.getHeaderField("Content-MD5");
                    in = new BufferedInputStream(connection.getInputStream());
                    if (modPackSize == 0) {
                        modPackSize = connection.getContentLength();
                    } else {
                        if (amount + connection.getContentLength() != modPackSize) {
                            throw new IOException("Resume failed");
                        }
                        Logger.logInfo("Resume started sucessfully");
                    }
                    while ((count = in.read(data, 0, 1024)) != -1) {
                        fout.write(data, 0, count);
                        if (count > 0) {
                            retryCount = 5;
                        }
                        ModManager.this.downloadedPerc = ModManager.this.downloadedPerc + (double)count * 1.0 / (double)modPackSize * 100.0;
                        amount += count;
                        if (++steps <= 100) continue;
                        steps = 0;
                        final String txt = amount / 1024 + "Kb / " + modPackSize / 1024 + "Kb";
                        final int perc = (int)ModManager.this.downloadedPerc * 100;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ModManager.this.progressBar.setValue(perc);
                                ModManager.this.label.setText(txt);
                            }
                        });
                    }
                }
                catch (MalformedURLException e) {
                    Logger.logError("Error while downloading modpack", e);
                }
                catch (IOException e) {
                    Logger.logError("Error while downloading modpack", e);
                }
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (connection == null) continue;
                    connection.disconnect();
                }
                catch (IOException e) {
                    Logger.logWarn("Error while downloading modpack", e);
                }
            } while (amount < modPackSize && (amount > startAmount || retryCount-- > 0));
            try {
                if (fout != null) {
                    fout.flush();
                    fout.close();
                }
            }
            catch (IOException e) {
                Logger.logWarn("Error while downloading modpack", e);
            }
            return md5;
        }

        protected boolean downloadModPack(String modPackName, String dir) {
            String md5;
            String baseLink;
            ModPack pack;
            String installPath;
            block18: {
                Logger.logInfo("Downloading Mod Pack");
                TrackerUtils.sendPageView("net/ftb/tools/ModManager.java", "Downloaded: " + modPackName + " v." + curVersion.replace('_', '.'));
                String dynamicLoc = OSUtils.getCacheStorageLocation();
                installPath = Settings.getSettings().getInstallPath();
                pack = ModPack.getSelectedPack();
                baseLink = pack.isPrivatePack() ? "privatepacks/" + dir + "/" + curVersion + "/" : "modpacks/" + dir + "/" + curVersion + "/";
                baseDynamic = new File(dynamicLoc, "ModPacks" + sep + dir + sep);
                Logger.logDebug("pack dir: " + dir);
                Logger.logDebug("dynamicLoc: " + dynamicLoc);
                Logger.logDebug("installPath: " + installPath);
                Logger.logDebug("baseLink: " + baseLink);
                baseDynamic.mkdirs();
                md5 = "";
                try {
                    File packFile = new File(baseDynamic, modPackName);
                    if (dir.equals("mojang_vanilla") || packFile.exists() && DownloadUtils.backupIsValid(packFile, baseLink + modPackName)) break block18;
                    try {
                        new File(baseDynamic, modPackName).createNewFile();
                        md5 = this.downloadUrl(baseDynamic.getPath() + sep + modPackName, DownloadUtils.getCreeperhostLink(baseLink + modPackName));
                    }
                    catch (IOException e) {
                        Logger.logWarn("Error while downloading modpack", e);
                    }
                    String animation = pack.getAnimation();
                    File animationFile = new File(baseDynamic.getPath() + sep + animation);
                    if (!animation.equalsIgnoreCase("empty") && !animationFile.exists()) {
                        this.downloadUrl(baseDynamic.getPath() + sep + animation, DownloadUtils.getCreeperhostLink(baseLink + animation));
                    }
                }
                catch (Exception e) {
                    Logger.logError("Error validating pack archive", e);
                }
            }
            try {
                if (!dir.equals("mojang_vanilla") && (md5 == null || md5.isEmpty() ? DownloadUtils.backupIsValid(new File(baseDynamic, modPackName), baseLink + modPackName) : DownloadUtils.isValid(new File(baseDynamic, modPackName), md5))) {
                    Logger.logDebug("Extracting pack.");
                    Logger.logDebug("Purging mods, coremods, instMods");
                    ModManager.clearModsFolder(pack);
                    FileUtils.delete(new File(installPath, dir + "/minecraft/coremods"));
                    FileUtils.delete(new File(installPath, dir + "/instMods/"));
                    boolean saveExists = false;
                    if (pack.getBundledMap()) {
                        try {
                            if (new File(installPath, dir + "/minecraft/saves").exists()) {
                                saveExists = true;
                                FileUtils.delete(new File(installPath, dir + "/minecraft/saves.ftbtmp"));
                                FileUtils.copyFolder(new File(installPath, dir + "/minecraft/saves"), new File(installPath, dir + "/minecraft/saves.ftbtmp"), true);
                            }
                        }
                        catch (Exception e) {
                            Logger.logError("error backing up map", e);
                        }
                    }
                    Logger.logDebug("Extracting pack.");
                    FileUtils.extractZipTo(baseDynamic.getPath() + sep + modPackName, baseDynamic.getPath());
                    if (pack.getBundledMap() && saveExists) {
                        try {
                            if (new File(installPath, dir + "/minecraft/saves").exists() && new File(installPath, dir + "/minecraft/saves.ftbtmp").exists()) {
                                FileUtils.delete(new File(installPath, dir + "/minecraft/saves"));
                            }
                            if (new File(installPath, dir + "/minecraft/saves.ftbtmp").exists()) {
                                FileUtils.copyFolder(new File(installPath, dir + "/minecraft/saves.ftbtmp"), new File(installPath, dir + "/minecraft/saves"), true);
                                FileUtils.delete(new File(installPath, dir + "/minecraft/saves.ftbtmp"));
                            }
                        }
                        catch (Exception e) {
                            Logger.logError("error restoring map", e);
                        }
                    }
                    File version = new File(installPath, dir + sep + "version");
                    BufferedWriter out = new BufferedWriter(new FileWriter(version));
                    out.write(curVersion.replace("_", "."));
                    out.flush();
                    out.close();
                    Logger.logDebug("Pack extracted, version tagged.");
                    return true;
                }
                if (!dir.equals("mojang_vanilla")) {
                    ErrorUtils.tossError("Error downloading modpack!!!");
                    return false;
                }
                File version = new File(installPath, dir + sep + "version");
                BufferedWriter out = new BufferedWriter(new FileWriter(version));
                out.write(curVersion.replace("_", "."));
                out.flush();
                out.close();
                Logger.logDebug("Vanilla version tagged.");
                return true;
            }
            catch (IOException e) {
                Logger.logError("Error while extracting modpack", e);
                return false;
            }
        }
    }
}

